//
//  InterfaceController.swift
//  dismissController WatchKit Extension
//
//  Created by yoshiyuki oshige on 2015/04/01.
//  Copyright (c) 2015年 yoshiyuki oshige. All rights reserved.
//

import WatchKit
import Foundation


class InterfaceController: WKInterfaceController {
    
    // ラベルをOutlet接続する
    @IBOutlet weak var myLabel: WKInterfaceLabel!
    
    override func awakeWithContext(context: AnyObject?) {
        super.awakeWithContext(context)
        
        // Configure interface objects here.
        
    }
    
    override func willActivate() {
        // This method is called when watch view controller is about to be visible to user
        
        super.willActivate()
        
        // スイッチの値が保存されている変数isOnを見てラベルのテキストを設定する
        // isOnはDetailInterfaceController.swiftで宣言されている
        if isOn {
            myLabel.setText("on")
        } else {
            myLabel.setText("off")
        }
    }

    override func didDeactivate() {
        // This method is called when watch view controller is no longer visible
        super.didDeactivate()
    }

}
